---
Difficulty: Medium
Source: Daily-Question(POTD 22-Nov)
Tags:
    - Array
    - Hash Table
    - Matrix
---


# 🚀 *1072 - Flip Columns for Maximum Number of Equal Rows* 🧠

### Problem Link:
[**LeetCode - Flip Columns for Maximum Number of Equal Rows**](https://leetcode.com/problems/flip-columns-for-maximum-number-of-equal-rows/description/?envType=daily-question&envId=2024-11-22)

## 💡 **Problem Breakdown:**

You are given an `m x n` binary matrix. You can choose any number of columns in the matrix and flip every cell in that column (i.e., change the value of the cell from `0` to `1` or vice versa). Your task is to find the maximum number of rows that have all values equal after flipping some number of columns.

### Key Insights:
- **Flipping Columns:** Flipping a column will change all the values in that column from `0` to `1` or `1` to `0`. 
- **Row Matching:** After any number of column flips, the goal is to maximize the number of rows where all the values in that row are equal (either all `0s` or all `1s`).

## 🎯 **My Approach:**

1. **Matrix Representation:**
   - For each row in the matrix, find the pattern that it forms.
   - If flipping any columns results in a row of all equal values, track the row's pattern.

2. **Key Generation for Row Patterns:**
   - Generate the "flip-key" for each row. If the first element of the row is `1`, flip all the values in the row; otherwise, leave the row unchanged.

3. **Count Frequency of Patterns:**
   - Use a hash map (or dictionary) to count the occurrences of each unique row pattern (after considering possible flips).
   
4. **Maximize Equal Rows:**
   - The result will be the highest frequency of a row pattern in the hash map, which will represent the maximum number of equal rows after flips.

## 🔍 **Example Walkthrough:**

### Example 1:
**Input:**  
`matrix = [[0,1],[1,1]]`  
**Output:**  
`1`

**Explanation:**  
- Flipping no columns results in one row with equal values.

### Example 2:
**Input:**  
`matrix = [[0,1],[1,0]]`  
**Output:**  
`2`

**Explanation:**  
- After flipping the first column, both rows become equal.

### Example 3:
**Input:**  
`matrix = [[0,0,0],[0,0,1],[1,1,0]]`  
**Output:**  
`2`

**Explanation:**  
- Flipping the first two columns results in the last two rows being equal.

## 🕒 **Time Complexity:**

- **Time Complexity:** O(m * n) — We need to iterate over all rows and columns to generate the key for each row and count occurrences.
- **Space Complexity:** O(m * n) — We store the key patterns and their counts, which requires space proportional to the number of rows.

## 📝 **Solution Code**

## Code (C):

```c
int maxEqualRowsAfterFlips(int** matrix, int matrixSize, int* matrixColSize) {
    char **keyArray = (char **)malloc(matrixSize * sizeof(char *));
    int *count = (int *)calloc(matrixSize, sizeof(int));
    int maxCount = 0;

    for (int i = 0; i < matrixSize; i++) {
        int flip = matrix[i][0] == 1;
        keyArray[i] = (char *)malloc(matrixColSize[i] + 1);  

        for (int j = 0; j < matrixColSize[i]; j++) {
            if (flip) {
                keyArray[i][j] = '0' + (1 - matrix[i][j]);  
            } else {
                keyArray[i][j] = '0' + matrix[i][j];  
            }
        }
        keyArray[i][matrixColSize[i]] = '\0'; 

        int found = 0;
        for (int j = 0; j < i; j++) {
            if (strcmp(keyArray[i], keyArray[j]) == 0) {
                count[j]++;
                found = 1;
                break;
            }
        }

        if (!found) {
            count[i] = 1;
        }
    }

    for (int i = 0; i < matrixSize; i++) {
        if (count[i] > maxCount) {
            maxCount = count[i];
        }
    }

    for (int i = 0; i < matrixSize; i++) {
        free(keyArray[i]);
    }
    free(keyArray);
    free(count);

    return maxCount;
}
```

## Code (C++):

```cpp
class Solution {
public:
    int maxEqualRowsAfterFlips(vector<vector<int>>& matrix) {
        unordered_map<string, int> count;
        int maxCount = 0;

        for (const auto& row : matrix) {
            string key;
            bool flip = row[0] == 1;

            for (int num : row) {
                key += flip ? ('0' + (1 - num)) : ('0' + num);
            }

            count[key]++;
            maxCount = max(maxCount, count[key]);
        }

        return maxCount;
    }
};
```

## Code (Java):

```java
class Solution {
    public int maxEqualRowsAfterFlips(int[][] matrix) {
        Map<String, Integer> patternCount = new HashMap<>();
        int maxCount = 0;

        for (int[] row : matrix) {
            StringBuilder pattern = new StringBuilder();
            int firstElement = row[0];

            for (int val : row) {
                pattern.append((val ^ firstElement) == 0 ? '0' : '1');
            }

            patternCount.put(pattern.toString(), patternCount.getOrDefault(pattern.toString(), 0) + 1);
            maxCount = Math.max(maxCount, patternCount.get(pattern.toString()));
        }

        return maxCount;
    }
}
```

## Code (Python3):

```python
from collections import defaultdict
from typing import List

class Solution:
    def maxEqualRowsAfterFlips(self, matrix: List[List[int]]) -> int:
        count = defaultdict(int)

        for row in matrix:
            row_key = tuple(row) if row[0] == 0 else tuple(1 - n for n in row)
            count[row_key] += 1

        return max(count.values()) 
```

## Code (Rust):

```rust
use std::collections::HashMap;

impl Solution {
    pub fn max_equal_rows_after_flips(matrix: Vec<Vec<i32>>) -> i32 {
        let mut count = HashMap::new();
        let mut max_count = 0;

        for row in matrix.iter() {
            let flip = row[0] == 1;
            let key: Vec<i32> = row.iter()
                                   .map(|&num| if flip { 1 - num } else { num })
                                   .collect();

            *count.entry(key.clone()).or_insert(0) += 1;
            max_count = max_count.max(*count.get(&key).unwrap());
        }

        max_count
    }
} 
```

## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
